/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.gui.IButton;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.IGuiEntity;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.gui.ILabel;
import noppes.npcs.api.gui.IScroll;
import noppes.npcs.api.gui.ITextField;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.ScriptContainer;

public class CustomGuiWrapper
implements ICustomGui {
    String backgroundTexture = "";
    List<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
    int height;
    int id;
    boolean pauseGame;
    private EntityPlayer player;
    int playerInvX;
    int playerInvY;
    ScriptContainer scriptHandler;
    boolean showPlayerInv;
    boolean showPlayerSlots = true;
    boolean isIndependent = false;
    List<IItemSlot> slots = new ArrayList<IItemSlot>();
    int width;
    public int stretched;
    public int bgW;
    public int bgH;
    public int bgTx;
    public int bgTy;

    public CustomGuiWrapper(EntityPlayer player) {
        this.player = player;
        this.stretched = 0;
        this.bgW = 0;
        this.bgH = 0;
        this.bgTx = 256;
        this.bgTy = 256;
    }

    public CustomGuiWrapper(int id, int width, int height, boolean pauseGame, EntityPlayer player) {
        this(player);
        this.id = id;
        this.width = width;
        this.height = height;
        this.pauseGame = pauseGame;
        this.scriptHandler = ScriptContainer.Current;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addButton(int id, String label, int x, int y, int width, int height) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IGuiEntity addEntity(int id, int x, int y, IEntity<?> entity) {
        CustomGuiEntityWrapper component = new CustomGuiEntityWrapper(id, x, y, entity);
        this.components.add(component);
        return (IGuiEntity)this.components.get(this.components.size() - 1);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y) {
        return this.addItemSlot(x, y, ItemScriptedWrapper.AIR);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y, IItemStack stack) {
        CustomGuiItemSlotWrapper slot = new CustomGuiItemSlotWrapper(x, y, stack);
        this.slots.add(slot);
        return slot;
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return (ILabel)this.components.get(this.components.size() - 1);
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height, int color) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height, color);
        this.components.add(component);
        return (ILabel)this.components.get(this.components.size() - 1);
    }

    @Override
    public IScroll addScroll(int id, int x, int y, int width, int height, String[] list) {
        CustomGuiScrollWrapper component = new CustomGuiScrollWrapper(id, x, y, width, height, list);
        this.components.add(component);
        return (IScroll)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITextField addTextField(int id, int x, int y, int width, int height) {
        CustomGuiTextFieldWrapper component = new CustomGuiTextFieldWrapper(id, x, y, width, height);
        this.components.add(component);
        return (ITextField)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture, textureX, textureY);
        this.components.add(component);
        return (IButton)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height);
        this.components.add(component);
        return (ITexturedRect)this.components.get(this.components.size() - 1);
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height, textureX, textureY);
        this.components.add(component);
        return (ITexturedRect)this.components.get(this.components.size() - 1);
    }

    public ICustomGui fromNBT(NBTTagCompound tag) {
        this.id = tag.func_74762_e("id");
        this.width = tag.func_74759_k("size")[0];
        this.height = tag.func_74759_k("size")[1];
        this.pauseGame = tag.func_74767_n("pause");
        this.backgroundTexture = tag.func_74779_i("bgTexture");
        this.stretched = tag.func_74762_e("bgStretched");
        this.bgW = tag.func_74762_e("bgWidth");
        this.bgH = tag.func_74762_e("bgHeight");
        this.bgTx = tag.func_74762_e("bgTextureX");
        this.bgTy = tag.func_74762_e("bgTextureY");
        this.isIndependent = tag.func_74767_n("isIndependent");
        ArrayList<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
        NBTTagList list = tag.func_150295_c("components", 10);
        for (NBTBase b : list) {
            CustomGuiComponentWrapper component = CustomGuiComponentWrapper.createFromNBT((NBTTagCompound)b);
            components.add(component);
        }
        this.components = components;
        ArrayList<IItemSlot> slots = new ArrayList<IItemSlot>();
        list = tag.func_150295_c("slots", 10);
        for (NBTBase b2 : list) {
            CustomGuiItemSlotWrapper component2 = (CustomGuiItemSlotWrapper)CustomGuiComponentWrapper.createFromNBT((NBTTagCompound)b2);
            slots.add(component2);
        }
        this.slots = slots;
        if (this.player instanceof EntityPlayerMP) {
            this.setPlayer((EntityPlayerMP)this.player);
        }
        this.showPlayerInv = tag.func_74767_n("showPlayerInv");
        this.showPlayerSlots = tag.func_74767_n("showPlayerSlots");
        if (this.showPlayerInv) {
            this.playerInvX = tag.func_74759_k("pInvPos")[0];
            this.playerInvY = tag.func_74759_k("pInvPos")[1];
        }
        return this;
    }

    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public ICustomGuiComponent getComponent(int componentID) {
        for (ICustomGuiComponent component : this.components) {
            if (component.getId() != componentID) continue;
            return component;
        }
        return null;
    }

    @Override
    public ICustomGuiComponent[] getComponents() {
        return this.components.toArray(new ICustomGuiComponent[0]);
    }

    public boolean getDoesPauseGame() {
        return this.pauseGame;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getPlayerInvX() {
        return this.playerInvX;
    }

    public int getPlayerInvY() {
        return this.playerInvY;
    }

    public ScriptContainer getScriptHandler() {
        return this.scriptHandler;
    }

    public boolean getShowPlayerInv() {
        return this.showPlayerInv;
    }

    public boolean getShowPlayerSlots() {
        return this.showPlayerInv && this.showPlayerSlots;
    }

    @Override
    public IItemSlot[] getSlots() {
        if (this.player instanceof EntityPlayerMP) {
            this.setPlayer((EntityPlayerMP)this.player);
        }
        return this.slots.toArray(new IItemSlot[0]);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void removeComponent(int componentID) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).getId() != componentID) continue;
            this.components.remove(i);
            if (this.player instanceof EntityPlayerMP) {
                this.update((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.player));
            }
            return;
        }
    }

    @Override
    public void setBackgroundTexture(int width, int height, int textureX, int textureY, int stretched, String resourceLocation) {
        this.backgroundTexture = resourceLocation;
        this.stretched = stretched;
        this.bgW = width;
        this.bgH = height;
        this.bgTx = textureX;
        this.bgTy = textureY;
    }

    @Override
    public void setBackgroundTexture(String resourceLocation) {
        this.backgroundTexture = resourceLocation;
        this.stretched = 0;
        this.bgW = 0;
        this.bgH = 0;
        this.bgTx = 256;
        this.bgTy = 256;
    }

    @Override
    public void setDoesPauseGame(boolean pauseGame) {
        this.pauseGame = pauseGame;
    }

    public void setPlayer(EntityPlayerMP player) {
        this.player = player;
        if (this.slots.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.slots.size(); ++i) {
            CustomGuiItemSlotWrapper slot = (CustomGuiItemSlotWrapper)this.slots.get(i);
            slot.setPlayer(player);
            slot.setIndex(i);
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public void showPlayerInventory(int x, int y) {
        this.showPlayerInv = true;
        this.showPlayerSlots = false;
        this.playerInvX = x;
        this.playerInvY = y;
    }

    @Override
    public void showPlayerInventory(int x, int y, boolean showSlots) {
        this.showPlayerInv = true;
        this.playerInvX = x;
        this.playerInvY = y;
        this.showPlayerSlots = showSlots;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        tag.func_74783_a("size", new int[]{this.width, this.height});
        tag.func_74757_a("pause", this.pauseGame);
        tag.func_74778_a("bgTexture", this.backgroundTexture);
        tag.func_74768_a("bgStretched", this.stretched);
        tag.func_74768_a("bgWidth", this.bgW);
        tag.func_74768_a("bgHeight", this.bgH);
        tag.func_74768_a("bgTextureX", this.bgTx);
        tag.func_74768_a("bgTextureY", this.bgTy);
        tag.func_74757_a("isIndependent", this.isIndependent);
        NBTTagList list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.components) {
            if (iCustomGuiComponent == null) continue;
            list.func_74742_a((NBTBase)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("components", (NBTBase)list);
        list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.slots) {
            list.func_74742_a((NBTBase)((CustomGuiItemSlotWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("slots", (NBTBase)list);
        tag.func_74757_a("showPlayerInv", this.showPlayerInv);
        tag.func_74757_a("showPlayerSlots", this.showPlayerSlots);
        if (this.showPlayerInv) {
            tag.func_74783_a("pInvPos", new int[]{this.playerInvX, this.playerInvY});
        }
        return tag;
    }

    @Override
    public void update(IPlayer<?> player) {
        CustomGuiController.updateGui((PlayerWrapper)player, this);
        ((EntityPlayer)player.getMCEntity()).field_71070_bA.func_75142_b();
    }

    @Override
    public void updateComponent(ICustomGuiComponent component) {
        for (int i = 0; i < this.components.size(); ++i) {
            ICustomGuiComponent c = this.components.get(i);
            if (c.getId() != component.getId()) continue;
            this.components.set(i, component);
            if (this.player instanceof EntityPlayerMP) {
                this.update((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.player));
            }
            return;
        }
    }
}

